/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.camera.button;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderClient;
import io.github.mortuusars.exposure.gui.screen.element.IElementWithTooltip;
import io.github.mortuusars.exposure.util.Fov;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class FocalLengthButton
extends ImageButton
implements IElementWithTooltip {
    private final Screen screen;
    private final int secondaryFontColor;
    private final int mainFontColor;

    public FocalLengthButton(Screen screen, int x, int y, int width, int height, int u, int v, ResourceLocation texture) {
        super(x, y, width, height, u, v, height, texture, 256, 256, button -> {}, (Component)Component.m_237119_());
        this.screen = screen;
        this.secondaryFontColor = Config.Client.getSecondaryFontColor();
        this.mainFontColor = Config.Client.getMainFontColor();
    }

    public void m_6303_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6303_(poseStack, mouseX, mouseY, partialTick);
        int focalLength = (int)Math.round(Fov.fovToFocalLength(ViewfinderClient.getCurrentFov()));
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent text = Component.m_237110_((String)"gui.exposure.viewfinder.focal_length", (Object[])new Object[]{focalLength});
        int textWidth = font.m_92852_((FormattedText)text);
        int xPos = 17 + (29 - textWidth) / 2;
        font.m_92889_(poseStack, (Component)text, (float)(this.f_93620_ + xPos), (float)(this.f_93621_ + 8), this.secondaryFontColor);
        font.m_92889_(poseStack, (Component)text, (float)(this.f_93620_ + xPos), (float)(this.f_93621_ + 7), this.mainFontColor);
    }

    @Override
    public void m_7428_(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
        this.screen.m_96602_(poseStack, (Component)Component.m_237115_((String)"gui.exposure.viewfinder.focal_length.tooltip"), mouseX, mouseY);
    }
}

